/****************************************************************************/
/**                                                                        **/
/**                    Driver Install API Sample Program                   **/
/**                                                                        **/
/**                   Aladdin Knowledge Systems, Germany                   **/
/****************************************************************************/
#include <stdio.h>
#include <conio.h>
#include <string.h>
#include <windows.h>
#include "hiapi.h"

#define VERSION "4.70"

BOOL  CheckParam         (char *, char *, BOOL);
DWORD DisplayResult      (DWORD);
void  DisplayVersions    (DWORD);
void  DisplayProcessList (void);
BOOL  SetParam           (DWORD, char *, char *, BOOL);
BOOL  GetYesNoKey        (void);
BOOL  DoInstall          (int, char *, BOOL);
BOOL  DoRemove           (DWORD);
BOOL  DriverInstalled    (void);

DWORD OSVersion;
BOOL  ValidParam = FALSE;
BOOL  ExtendedHelp = FALSE;
BOOL  UnsignedFlag = FALSE;

int main(int argc, char *argv[])
{
int i;

#ifdef HLDINSTD
printf( "HLDINSTD -- Hardlock Device Driver Installation for Win32, Version %s.\n", VERSION);
#else
printf( "HLDINST -- Hardlock Device Driver Installation for Win32, Version %s.\n", VERSION);
#endif
printf( "(c) Copyright 1998-2002, Aladdin Knowledge Systems Ltd.\n");

/* ---------------------------- */
/* Check the parameters and do: */
/* ---------------------------- */
if ((argc == 2) && argv[1][0] != '-' && argv[1][0] != '/')
  {
  DoInstall(argc, argv[1], FALSE);
  printf("\n* Done.\n");
  return 0;
  }

if (argc == 2)
  {
  if (CheckParam(argv[1], "help", FALSE) == TRUE)
    ExtendedHelp = TRUE;
  }

OSVersion = HIGetOSType();
for (i = 0; i < argc; i++)
  {
  if (CheckParam(argv[i], "install", FALSE) == TRUE)
    DoInstall(argc, argv[1], FALSE);

  if (CheckParam(argv[i], "installu", TRUE) == TRUE)
    DoInstall(argc, argv[1], TRUE);

  if (CheckParam(argv[i], "remove", FALSE) == TRUE)
    DoRemove(0);

  if (CheckParam(argv[i], "fremove", FALSE) == TRUE)
    DoRemove(HI_KILL_PROCESS);

  if (CheckParam(argv[i], "dpa", FALSE) == TRUE)
    SetParam(HI_DISABLE_DPA, "NO", "Remove DisableDPA from registry...", TRUE);

  if (CheckParam(argv[i], "nodpa", FALSE) == TRUE)
    SetParam(HI_DISABLE_DPA, "YES", "Set DisableDPA in registry...", TRUE);

  if (CheckParam(argv[i], "nousb", FALSE) == TRUE)
    SetParam(HI_USE_USB, "NO", "Disable USB search in registry...", TRUE);

  if (CheckParam(argv[i], "usb", FALSE) == TRUE)
    SetParam(HI_USE_USB, "YES", "Enable USB search in registry...", TRUE);

  if (CheckParam(argv[i], "nopci", FALSE) == TRUE)
    SetParam(HI_USE_PCI, "NO", "Disable search on PCI boards in registry...", TRUE);

  if (CheckParam(argv[i], "pci", FALSE) == TRUE)
    SetParam(HI_USE_PCI, "YES", "Enable search on PCI boards in registry...", TRUE);

  if (CheckParam(argv[i], "novdd", FALSE) == TRUE)
    SetParam(HI_HL_VDD, "NO", "Do not register hlvdd.dll...", TRUE);

  if (CheckParam(argv[i], "vdd", FALSE) == TRUE)
    SetParam(HI_HL_VDD, "YES", "Register hlvdd.dll...", TRUE);

  if (CheckParam(argv[i], "noports", FALSE) == TRUE)
    {
    SetParam(HI_IO_PORT_ADDRESS0, "", "Enable ports only known to NT in registry...", FALSE);
    SetParam(HI_IO_PORT_ADDRESS1, "", NULL, FALSE);
    SetParam(HI_IO_PORT_ADDRESS2, "", NULL, TRUE);
    }

  if (CheckParam(argv[i], "cli", FALSE) == TRUE)
    SetParam(HI_USE_STI_CLI, "YES", "Enable usage of CLI during port access in registry...", TRUE);

  if (CheckParam(argv[i], "noCli", FALSE) == TRUE)
    SetParam(HI_USE_STI_CLI, "No",  "Enable usage of critical frame during port access in registry...", TRUE);

  if (CheckParam(argv[i], "info", FALSE) == TRUE)
    {
    DisplayVersions(OSVersion);
    DisplayProcessList();
    }

  if (CheckParam(argv[i], "allports", FALSE) == TRUE)
    {
    SetParam(HI_IO_PORT_ADDRESS0, "278", "Enable use of port 0x278 in registry...", FALSE);
    SetParam(HI_IO_PORT_ADDRESS1, "378", "Enable use of port 0x378 in registry...", FALSE);
    SetParam(HI_IO_PORT_ADDRESS2, "3bc", "Enable use of port 0x3bc in registry...", TRUE);
    }

  if (CheckParam(argv[i], "ECPRetry:", TRUE) == TRUE)
    SetParam(HI_ECP_RETRY, argv[i]+10,  "Set ECP Retry counter in registry...", TRUE);

  if (CheckParam(argv[i], "PAllocRetry:", TRUE) == TRUE)
    SetParam(HI_PORT_ALLOC_RETRY_COUNT, argv[i]+13,  "Set Port allocation retry timeout in registry...", TRUE);

  if (CheckParam(argv[i], "PAllocFunc:", TRUE) == TRUE)
    SetParam(HI_PORT_ALLOC_FUNCTIONALITY, argv[i]+12, "Set Port allocation method in registry...", TRUE);

  if (CheckParam(argv[i], "SetFlag:", TRUE) == TRUE)
    SetParam(HI_SET_FLAG, argv[i]+9,  "Set Flag in registry...", TRUE);

  if (CheckParam(argv[i], "ResetFlag:", TRUE) == TRUE)
    SetParam(HI_RESET_FLAG, argv[i]+11,  "Reset Flag in registry...", TRUE);


  /* HLINST.EXE compatibility */
  /* ------------------------ */
  if (CheckParam(argv[i], "no", FALSE) == TRUE)
    {
    SetParam(HI_IO_PORT_ADDRESS0, "", "Enable ports only known to NT in registry...", FALSE);
    SetParam(HI_IO_PORT_ADDRESS1, "", NULL, FALSE);
    SetParam(HI_IO_PORT_ADDRESS2, "", NULL, TRUE);
    }

  if (CheckParam(argv[i], "d", FALSE) == TRUE)
    DoRemove(0);

  if (CheckParam(argv[i], "df", FALSE) == TRUE)
    DoRemove(HI_KILL_PROCESS);
  }

if ((argc < 2) || (ValidParam == FALSE) || ExtendedHelp == TRUE)
  {
#ifdef HLDINSTD
  printf("\n    Usage: HLDINSTD [<path>] <parameter>\n");
#else
  printf("\n    Usage: HLDINST [<path>] <parameter>\n");
#endif
  printf("\n    Basic functions:");
  printf("\n      -info          Get version information about drivers & processes.");
  printf("\n      -install       Install device drivers");
  printf("\n      -remove        Remove device drivers.");
  printf("\n      -fremove       Force remove (kill open processes without query).");
  printf("\n      -help          Display extended settings.");


  if (ExtendedHelp == TRUE)
    {
    printf("\n\n    Adjust behaviour:");
    printf("\n      -USB           Default. Search for USB Hardlock.");
    printf("\n      -noUSB         Don't search for USB Hardlock.");
    printf("\n      -Cli           Use CLI (clear interrupts) during port access.");
    printf("\n      -NoCli         Default. Don't use CLI (critical frame is used).");
    printf("\n      -ECPRetry:x    Default x=65535. Set counter waiting for ECP queue.");

    switch (OSVersion)
      {
      case VER_PLATFORM_WIN32s:
        break;
      case VER_PLATFORM_WIN32_WINDOWS:
        break;
      case VER_PLATFORM_WIN32_NT:
        printf("\n      -DPA           Default. Compatibility for Hardlock API older 3.20.");
        printf("\n      -noDPA         Set \"DisableDPA\". No compatibility for HL API older 3.20.");
        printf("\n      -allports      Default. Use 0x378, 0x278, 0x3bc as ports.");
        printf("\n      -noports       Only use LPT port addresses known to Windows NT.");
        printf("\n      -PAllocRetry:x Default x=20. Set timeout for allocating port.");
        printf("\n      -PAllocFunc:x  Default x=3. Set port allocation method.");
		printf("\n      -VDD           Default. Set registry entry for hlvdd.dll.");
		printf("\n      -noVDD         No registry key for hlvdd.dll.");
        break;
      }
    }

  printf("\n");
  printf("\n    If a <path> is given as first parameter, the driver images will be taken");
  printf("\n    from the specified directory. Any file which cannot be found in this path");
  printf("\n    will be taken from internally.\n");
  return (0);
  }

printf("\n* Done.\n");
return (0);
}

/******************************************************************************/
BOOL DoInstall (int cnt, char * drvPath, BOOL UnsignedFlag)
/******************************************************************************/
{
DWORD ret;
DWORD KillFlag = 0;

install:
printf("\n* Installing device drivers...");
if ((cnt > 1) && drvPath[0] != '-' && drvPath[0] != '/')
  {
  printf("use files from: <%s>...", drvPath);
  if (!UnsignedFlag)
  	ret = HDDInstallEx(HI_INSTALL_HARDLOCK | KillFlag, NULL, drvPath, 0);
  else
	ret = HDDInstallEx(HI_INSTALL_HARDLOCK | HI_UNSIGNED | KillFlag, NULL, drvPath, 0);
  }
else
  if (!UnsignedFlag)
    ret = HDDInstallEx(HI_INSTALL_HARDLOCK | KillFlag, NULL, NULL, 0);
  else
	ret = HDDInstallEx(HI_INSTALL_HARDLOCK | HI_UNSIGNED | KillFlag, NULL, NULL, 0);

if (DisplayResult(ret) == PROCESSES_OPEN)
  {
  DisplayProcessList();
  if (GetYesNoKey() == TRUE)
    {
    KillFlag = KillFlag | HI_KILL_PROCESS;
    goto install;
    }
  }

return TRUE;
}

/******************************************************************************/
BOOL DoRemove (DWORD option)
/******************************************************************************/
{
DWORD ret;
DWORD KillFlag = 0;
KillFlag = KillFlag | option;

remove:
printf("\n* Removing device drivers...");
ret = HDDRemove(HI_REMOVE_HARDLOCK | KillFlag);

if (DisplayResult(ret) == PROCESSES_OPEN)
  {
  DisplayProcessList();
  if (GetYesNoKey() == TRUE)
    {
    KillFlag = KillFlag | HI_KILL_PROCESS;
    goto remove;
    }
  }

return TRUE;
}

/******************************************************************************/
DWORD DisplayResult (DWORD lastret)
/******************************************************************************/
{
DWORD Status;
char  HIErrorStr[512];
DWORD lpSystemError;
DWORD SubError;

if (lastret == HI_SUCCESS)
  {
  printf ("Success.");
  return (lastret);
  }

Status = HILastErrorEx(HIErrorStr, sizeof(HIErrorStr), &lpSystemError, &SubError, 0);
if (Status == HI_FAIL)
  {
  printf ("\nGetting the Aladdin Device Driver last error failed.\n");
  return (Status);
  }

switch (Status)
  {
  case WIN95_INSTALL_SUCCESSFUL_REBOOT:
    printf ("Success, but you need to reboot your system!!");
    break;
  case WIN95_REMOVED_SUCCESSFUL_REBOOT:
    printf ("Success, but you need to reboot your system!!");
    break;
  case SERVICE_IS_NOT_SUPPORTED:
    printf ("Service is not supported!!");
    break;
  case USER_HAVE_NO_ACCESS:
    printf ("You need Admin rights to execute this function!!");
    break;
  case HL_NT_SERVER_RUNNING:
    printf ("\n* HL-Server service is running. You have to stop the service first!!");
    break;
  default:
    printf( "\n\n");
    printf( "  API error        : 0x%lx\n", Status);
    printf( "  API sub error    : 0x%lx\n", SubError);
    printf( "  Last System error: 0x%lx\n", lpSystemError);
    printf( "  API error text   : %s\n",    HIErrorStr);
    break;
  }
return (Status);
}

/******************************************************************************/
void DisplayVersions (DWORD os)
/******************************************************************************/
{
DWORD ret;
HDDVersion InstVer, IntVer;

/* ----------------------------------------- */
/* Get informations about installed drivers: */
/* ----------------------------------------- */
ret = HIGetHDDVersion(&InstVer, &IntVer);
if (ret != HI_FAIL)
  {
  printf("\n  Installed driver versions:");
  printf("\n  --------------------------");
  printf("\n  (0.00 means not installed)\n");
  switch (os)
    {
    case VER_PLATFORM_WIN32s:
       printf("\n  HARDLOCK.VXD : %2d.%02d", InstVer.W3X_HL_VXD   >> 8, InstVer.W3X_HL_VXD   & 255);
       printf("\n  API_1LNM.DLL : %2d.%02d", InstVer.W3X_HL_16DLL >> 8, InstVer.W3X_HL_16DLL & 255);
       break;
    case VER_PLATFORM_WIN32_WINDOWS:
       printf("\n  HARDLOCK.VXD : %2d.%02d", InstVer.W9X_VXD    >> 8, InstVer.W9X_VXD    & 255);
       printf("\n  HLVDD.DLL    : %2d.%02d", InstVer.W9X_HL_VDD >> 8, InstVer.W9X_HL_VDD & 255);
       printf("\n  AKSUSB.SYS   : %2d.%02d", InstVer.W9X_USB    >> 8, InstVer.W9X_USB    & 255);
       break;
    case VER_PLATFORM_WIN32_NT:
       printf("\n  HARDLOCK.SYS  : %2d.%02d", InstVer.WNT_KDD    >> 8, InstVer.WNT_KDD    & 255);
       printf("\n  HLVDD.DLL     : %2d.%02d", InstVer.WNT_HL_VDD >> 8, InstVer.WNT_HL_VDD & 255);
       printf("\n  AKSUSB.SYS    : %2d.%02d", InstVer.WNT_USB    >> 8, InstVer.WNT_USB    & 255);
       printf("\n  AKSPCCARD.SYS : %2d.%02d", InstVer.WNT_PCCARD >> 8, InstVer.WNT_PCCARD & 255);
       break;
    }

  printf("\n\n  Versions included internally:");
  printf(  "\n  -----------------------------");
  switch (os)
    {
    case VER_PLATFORM_WIN32s:
       printf("\n  HARDLOCK.VXD : %2d.%02d", IntVer.W3X_HL_VXD   >> 8, IntVer.W3X_HL_VXD   & 255);
       printf("\n  API_1LNM.DLL : %2d.%02d", IntVer.W3X_HL_16DLL >> 8, IntVer.W3X_HL_16DLL & 255);
       break;
    case VER_PLATFORM_WIN32_WINDOWS:
       printf("\n  HARDLOCK.VXD : %2d.%02d", IntVer.W9X_VXD    >> 8, IntVer.W9X_VXD    & 255);
       printf("\n  HLVDD.DLL    : %2d.%02d", IntVer.W9X_HL_VDD >> 8, IntVer.W9X_HL_VDD & 255);
       printf("\n  AKSUSB.SYS   : %2d.%02d", IntVer.W9X_USB    >> 8, IntVer.W9X_USB    & 255);
       break;
    case VER_PLATFORM_WIN32_NT:
       printf("\n  HARDLOCK.SYS  : %2d.%02d", IntVer.WNT_KDD    >> 8, IntVer.WNT_KDD    & 255);
       printf("\n  HLVDD.DLL     : %2d.%02d", IntVer.WNT_HL_VDD >> 8, IntVer.WNT_HL_VDD & 255);
       printf("\n  AKSUSB.SYS    : %2d.%02d", IntVer.WNT_USB    >> 8, IntVer.WNT_USB    & 255);
       printf("\n  AKSPCCARD.SYS : %2d.%02d", IntVer.WNT_PCCARD >> 8, IntVer.WNT_PCCARD & 255);
       break;
    }
  printf("\n\n");
  }
 else
  DisplayResult(ret);
}

/******************************************************************************/
void DisplayProcessList (void)
/******************************************************************************/
{
DWORD Size, ProcNum, i;
ClientProcess * PrcBuff;

Size = HDDGetClientProcessSize();
		
if( Size != HI_FAIL )  /* no list of open processes on Win95/98 */
  {	
  if (Size == 0)
    {
    printf("\n* No processes accessing the drivers.");
    return;
    }

  PrcBuff = (ClientProcess *) malloc (Size);
  ProcNum = Size / sizeof(ClientProcess);

  HDDClientProcess (PrcBuff, &Size);

  printf("\n  List of open processes accessing the driver:");
  printf("\n  --------------------------------------------");
  for (i = 0; i < ProcNum; ++i, ++PrcBuff)
    {
    if (PrcBuff->ProcessType == W32)
      printf("\n  Type: Win32, Name: %s, PID: %u", PrcBuff->Name, PrcBuff->PID);

    if (PrcBuff->ProcessType == W16)
      printf("\n  Type: Win16, Name: %s, TaskID: %u", PrcBuff->Name, PrcBuff->PID);
    }
  }
printf("\n");
}

/******************************************************************************/
BOOL SetParam (DWORD what, char * value, char * Msg, BOOL Reload)
/******************************************************************************/
{
DWORD ret;
DWORD KillFlag = 0;

if (DriverInstalled() == FALSE)
  {
  printf("\n* Drivers not installed...");
  return FALSE;
  }

ret = HISetParameter(what, value);
if (Msg != NULL)
  {
  printf("\n* %s", Msg);
  DisplayResult(ret);
  }

if (Reload == TRUE)
  {
  if (OSVersion == VER_PLATFORM_WIN32_NT)
    {
  reload:
    printf("\n* Reloading driver...");
    ret = HDDInstallEx(HI_INSTALL_HARDLOCK | HI_INSTALL_RELOAD | KillFlag, 0, NULL, 0);
    if (DisplayResult(ret) == PROCESSES_OPEN)
      {
      DisplayProcessList();
      if (GetYesNoKey() == TRUE)
        {
        KillFlag = KillFlag | HI_KILL_PROCESS;
        goto reload;
        }
      }
    }
   else
    printf("\n* You have to reboot your system in order to take the changes affect...");
  }

return TRUE;
}

/******************************************************************************/
BOOL DriverInstalled (void)
/******************************************************************************/
{
HDDVersion InstVer, IntVer;
DWORD versions = 0;

if (HIGetHDDVersion(&InstVer, &IntVer) == HI_FAIL)
  return FALSE;

switch (OSVersion)
  {
  case VER_PLATFORM_WIN32s:
     versions = InstVer.W3X_HL_VXD;
     break;
  case VER_PLATFORM_WIN32_WINDOWS:
     versions = InstVer.W9X_VXD;
     break;
  case VER_PLATFORM_WIN32_NT:
     versions = InstVer.WNT_KDD;
     break;
  }

if (versions == 0)
  return FALSE;
 else
  return TRUE;
}

/******************************************************************************/
BOOL GetYesNoKey ()
/******************************************************************************/
{
char c;

printf("\n\n");
printf("  Removing the driver cannot continue unless these processes are terminated!\n");
printf("  If you tell the program to continue, it will try to terminate them, so\n");
printf("  be sure to save all your work before going on...\n");

do {
   printf("\n  Do you want to continue? (y/n)");
   fflush(stdin);
   scanf("%c", &c);
   if (c == 'n' || c == 'N') return FALSE;
   } while (c != 'y' && c != 'Y');

return TRUE;
}

/******************************************************************************/
BOOL CheckParam(char * arg, char * cmd, BOOL hasvalue)
/******************************************************************************/
{
if ((arg[0] != '-') && (arg[0] != '/'))
  return FALSE;

if (hasvalue == FALSE)
  {
  if (stricmp(arg + 1, cmd) == 0)
    {
    ValidParam = TRUE;
    return TRUE;
    }
  }
 else
  {
  if (strnicmp(arg + 1, cmd, strlen(cmd)) == 0)
    {
    ValidParam = TRUE;
    return TRUE;
    }
  }

return FALSE;
}

